/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ColorParticleData
implements ParticleOptions {
    private final float red;
    private final float green;
    private final float blue;

    protected ColorParticleData(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeFloat(this.red);
        packetBuffer.writeFloat(this.green);
        packetBuffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public static class DeserializationHelper {
        private DeserializationHelper() {
        }

        public static <T extends ColorParticleData> T deserialize(IColorParticleDataInitializer<T> initializer, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float r = stringReader.readFloat();
            stringReader.expect(' ');
            float g = stringReader.readFloat();
            stringReader.expect(' ');
            float b = stringReader.readFloat();
            stringReader.expect(' ');
            return initializer.initialize(r, g, b);
        }

        public static <T extends ColorParticleData> T read(IColorParticleDataInitializer<T> initializer, FriendlyByteBuf packetBuffer) {
            return initializer.initialize(packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }
    }

    public static interface IColorParticleDataInitializer<T extends ColorParticleData> {
        public T initialize(float var1, float var2, float var3);
    }
}

